#include <stdio.h>
#include <avr/io.h>

#include "atmega_bmp085_lib.h"
#include "uart.h"

int main(void)
{	
	int32_t temperature = 0;
	int32_t pressure = 0;
	int16_t BMP085_calibration_int16_t[8];
	int16_t BMP085_calibration_uint16_t[3];
	uint8_t error_code=0;

	// Initialize UART0
	uart_init();
	_delay_ms(11);
	// Initialize TWI
	i2cSetBitrate(1000);
	// Initialize BMP085
	BMP085_Calibration(BMP085_calibration_int16_t, BMP085_calibration_uint16_t,&error_code);
		
	printf("Error code: %d \n",error_code);
    while(1)
    {
		bmp085Convert(BMP085_calibration_int16_t, BMP085_calibration_uint16_t,&temperature, &pressure,&error_code);
		printf("%ld;%ld;%ld\n", temperature/10, pressure, bmp085CalcAltitude(pressure)/10);
		//printf("Temperature: %ld\n", temperature);
		//printf("Pressure: %ld Pa\n", pressure);	
		//printf("Altitude: %ld m\n\n", bmp085CalcAltitude(pressure)/10);
		_delay_ms(10);
    }
}
