#include <stdio.h>
#include <avr/io.h>
#include <util/delay.h>

//===================================  ==================================
// :
void adc_init(void){	
	ADCSRA = _BV(ADEN) | _BV(ADPS0) | _BV(ADPS1) | _BV(ADPS2); // prescaler = 128
}

//  :
uint32_t adc_read(uint8_t ch){	
	ADMUX = _BV(REFS0) | (ch & 0x1F);	// set channel (VREF = VCC)	
	ADCSRA &= ~_BV(ADIF);			// clear hardware "conversion complete" flag	
	ADCSRA |= _BV(ADSC);			// start conversion	

  	while(ADCSRA & _BV(ADSC));		// wait until conversion complete	

  	return ADC;				// read ADC (full 10 bits);
}

int main() {
	char mode=0; //  -   0
	int direct=0;
	uint16_t adc_result;

	#define ICR_MAX F_CPU/50  // ICR1(TOP) = fclk/(N*f) ; N-; f-;  1000000/1/50 = 20000
	#define OCR_MIN ICR_MAX/20
	#define OCR_MAX ICR_MAX/10
	#define OCR_CENTER (ICR_MAX/4/10)*3

	//      
	DDRB &= ~(1<<4);
	PORTB |= (1<<4);

	//   
	DDRC = (1<<1) | (1<<2) | (1<<3);
	PORTC |= (1<<(mode+1));
  
	//  PWM   1 (   PB1, PB2)
	TCCR1A = 0; //  PWM   
	ICR1 = ICR_MAX; //   50 

	//  Fast PWM mode via ICR1   1   
	TCCR1A = (1<<WGM11);
	TCCR1B = (1<<WGM13) | (1<<WGM12) | (1<<CS10);

	//  PB1  PB2  
	DDRB |= (1<<1) | (1<<2);
	
	//  PWM  port B1  B2
	TCCR1A |= (1<<COM1A1) | (1<<COM1B1);
	
	//  
	adc_init();

	while(1){
		//    ( )
		if ((PINB & (1<<4)) == 0) 
		{
			//    
			while ((PINB & (1<<4)) == 0) {
				_delay_ms(200);
			}

			mode++;
			if (mode > 2) {
				mode = 0;
			}

			//   
			PORTC &= ~((1<<1) | (1<<2) | (1<<3));
			PORTC |= (1<<(mode+1));
		}

		switch (mode){
		case 0:{
				//   ,      adc_result
				adc_result=adc_read(0);
				OCR1A = OCR_MIN+(adc_result * (OCR_MAX-OCR_MIN)/1024);
				OCR1B = OCR1A;
				break;
			}
		case 1:{
				//    
				direct=0;
				OCR1A = OCR_CENTER;
				OCR1B = OCR1A;
				break;
			}
		case 2:{
				//    
				if (direct==0){
					OCR1A++;
					OCR1B++;
					if (OCR1A >= OCR_MAX) {
						direct=1;
					}
				}
				if (direct==1){
					OCR1A--;
					OCR1B--;
					if (OCR1A <= OCR_MIN) {
						direct=0;
					}
				}
				_delay_ms(1);
				break;
			}
		}
	}
}
