#include <avr/io.h>
#include <util/delay.h>
#include "lcd_lib.h"

#include "ds1302.h"

char buffer[16]="";

int main()
{

//     (AM/PM     H12)
DateTime.Sec = 57;
DateTime.Min = 59;
DateTime.Hour = 11;
DateTime.Month = 8;
DateTime.Day = 16;
DateTime.Year = 11;
DateTime.WeekDay = 2;
DateTime.AMPM = AM;   //AM/PM
DateTime.H12_24 = H12;  //H12/H24

//     ds1302
DS1302_WriteDateTime();

//  
LCDinit();
LCDcursorOFF();
LCDclr();

while(1)
{
	//     ds1302
	DS1302_ReadDateTime();

	//      
	sprintf(buffer, "%02i:%02i:%02i", DateTime.Hour, DateTime.Min, DateTime.Sec);
	LCDGotoXY(0,0);
	LCDstring(buffer, 8);

	if (DateTime.H12_24 == H12) {
		if (DateTime.AMPM == AM){
			LCDsendChar('A');
		}
		else {
			LCDsendChar('P');
		}
		LCDsendChar('M');
	}

	sprintf(buffer, "%02i-%02i-%02i,%i", DateTime.Day, DateTime.Month, DateTime.Year, DateTime.WeekDay);
	LCDGotoXY(0,1);
	LCDstring(buffer, 10);


	_delay_ms(100);
}
}
