unit mainfrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, ActnList, CPortCtl, CPort, Menus;

type
  TMainForm = class(TForm)
    FilmsListBox: TListBox;
    OpenDialog: TOpenDialog;
    OpenButton: TButton;
    ProgressBar: TProgressBar;
    FilmMemo: TMemo;
    FilmTimer: TTimer;
    Edit1: TEdit;
    PlayButton: TButton;
    StopButton: TButton;
    ActionList: TActionList;
    OpenAction: TAction;
    PlayPauseAction: TAction;
    StopAction: TAction;
    ComPort: TComPort;
    FileListPopupMenu: TPopupMenu;
    RemoveFromList: TMenuItem;
    DeleteFromFileListAction: TAction;
    GroupBox1: TGroupBox;
    ComComboBox: TComComboBox;
    SearchBtn: TButton;
    GroupBox2: TGroupBox;
    TimerTrackBar: TTrackBar;
    procedure FilmTimerTimer(Sender: TObject);
    procedure FilmsListBoxClick(Sender: TObject);
    procedure OpenActionExecute(Sender: TObject);
    procedure PlayPauseActionExecute(Sender: TObject);
    procedure StopActionExecute(Sender: TObject);
    procedure TimerTrackBarChange(Sender: TObject);
    procedure ComComboBoxChange(Sender: TObject);
    procedure DeleteFromFileListActionExecute(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  CurrentFilm: Integer;
  CurrentKadr: Integer;

implementation

{$R *.dfm}

procedure TMainForm.FilmTimerTimer(Sender: TObject);
begin
  FilmTimer.Enabled := False;

  //     ,  
  if (FilmMemo.Lines.Count = 0) then
  begin
    if (FilmsListBox.Items.Count > 0) then
    begin
      inc(CurrentFilm);
      if (CurrentFilm > FilmsListBox.Items.Count -1) then
        CurrentFilm := 0;
      //  
      FilmMemo.Lines.LoadFromFile(FilmsListBox.Items[CurrentFilm]);
      CurrentKadr := 0;
      FilmsListBox.Selected[CurrentFilm] := True;
      ProgressBar.Max := FilmMemo.Lines.Count;
    end;
  end;

  if (FilmMemo.Lines.Count > 0) then
  begin
    Edit1.Text := 'set ' + FilmMemo.Lines[CurrentKadr] + ',' + #13#10;
    if (ComPort.Connected) then
    begin
      ComPort.WriteStr(Edit1.Text);
    end
    else begin
      StopActionExecute(Self);
    end;

    inc(CurrentKadr);
    //    
    if (CurrentKadr > FilmMemo.Lines.Count -1) then
    begin
      CurrentKadr := 0;
      FilmMemo.Lines.Clear;
    end;
    ProgressBar.Position := CurrentKadr + 1;
  end;


  FilmTimer.Enabled := True;
end;

procedure TMainForm.FilmsListBoxClick(Sender: TObject);
begin
  CurrentFilm := FilmsListBox.ItemIndex;
end;

procedure TMainForm.OpenActionExecute(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    FilmsListBox.Items.AddStrings(OpenDialog.Files);
    CurrentFilm := -1;
    CurrentKadr := -1;
    FilmMemo.Lines.Clear;
  end;
end;

procedure TMainForm.PlayPauseActionExecute(Sender: TObject);
begin
  if (FilmTimer.Enabled) then
  begin
    FilmTimer.Enabled := False;
  end
  else begin
    FilmTimer.Enabled := True;
  end;
end;

procedure TMainForm.StopActionExecute(Sender: TObject);
begin
  FilmTimer.Enabled := False;
  CurrentFilm := -1;
  CurrentKadr := -1;
  FilmMemo.Lines.Clear;
  ProgressBar.Position := 0;
end;

procedure TMainForm.TimerTrackBarChange(Sender: TObject);
begin
  FilmTimer.Interval := TimerTrackBar.Position;
  TimerTrackBar.Hint := IntToStr(TimerTrackBar.Position);
end;

procedure TMainForm.ComComboBoxChange(Sender: TObject);
begin
  ComPort.Connected := True;
end;

procedure TMainForm.DeleteFromFileListActionExecute(Sender: TObject);
begin
  FilmsListBox.DeleteSelected;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  StopActionExecute(Self);
  ComPort.Connected := False;
end;

end.
