#include <stdio.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <string.h>
//#include <util/delay.h>
#include "uart.h"

#define RXBAUD 9600
#define RXUBRR F_CPU/16/RXBAUD-1
#define RX_BUF_SIZE 48

#define LED_PORT PORTB
#define LED_PORT_DDR DDRB
#define LED_DSA PINB0
#define LED_CLK PINB1
#define LED_RESET PINB2

#define KEY_PORT PORTD
#define KEY_PORT_DDR DDRD
#define KEY_1 PIND2
#define KEY_2 PIND3
#define KEY_3 PIND4
#define KEY_4 PIND5

// 
uint8_t FLAGS[2];
#define FLAG_COMMAND     FLAGS[0]
#define FLAG_AUTORUN     FLAGS[1]

char    RXBuffer[RX_BUF_SIZE];
uint8_t RXi;
char    RXc;
uint8_t RXbyte[8];

uint8_t LEDbyte[8];
uint8_t LEDR=0;

///////////////////////////////////////////
// ,  
///////////////////////////////////////////
#define FilmInterval 50
#define FilmLength 587
unsigned char FilmData[FilmLength][8] PROGMEM =
{

{0,0,0,0,0,0,1,0},
{0,0,0,0,0,0,17,0},
{0,0,0,0,0,0,17,1},
{0,0,0,0,0,0,17,17},
{0,0,0,0,0,0,19,17},
{0,0,0,0,0,0,51,17},
{0,0,0,0,0,0,51,19},
{0,0,0,0,0,0,51,51},
{0,0,0,0,0,0,55,51},
{0,0,0,0,0,0,119,51},
{0,0,0,0,0,0,119,55},
{0,0,0,0,0,0,119,119},
{0,0,0,0,0,0,127,119},
{0,0,0,0,0,0,255,119},
{0,0,0,0,0,0,255,127},
{0,0,0,0,0,0,255,255},
{0,0,0,0,255,255,0,0},
{0,0,255,255,0,0,0,0},
{255,255,0,0,0,0,0,0},
{0,0,255,255,0,0,0,0},
{0,0,0,0,255,255,0,0},
{0,0,0,0,0,0,255,255},
{0,0,0,0,255,255,0,0},
{0,0,255,255,0,0,0,0},
{255,255,0,0,0,0,0,0},
{240,255,0,240,0,0,0,0},
{0,255,0,240,0,240,0,0},
{0,240,0,240,0,240,0,240},
{0,15,0,15,0,15,0,15},
{240,0,240,0,240,0,240,0},
{15,0,15,0,15,0,15,0},
{240,0,240,0,240,0,240,0},
{0,15,0,15,0,15,0,15},
{0,240,0,240,0,240,0,240},
{0,15,0,15,0,15,0,15},
{240,0,240,0,240,0,240,0},
{15,0,15,0,15,0,15,0},
{240,0,240,0,240,0,240,0},
{0,15,0,15,0,15,0,15},
{0,240,0,240,0,240,0,240},
{0,232,0,232,0,232,0,232},
{128,200,128,200,128,200,128,200},
{136,136,136,136,136,136,136,136},
{68,68,68,68,68,68,68,68},
{34,34,34,34,34,34,34,34},
{17,17,17,17,17,17,17,17},
{34,34,34,34,34,34,34,34},
{68,68,68,68,68,68,68,68},
{136,136,136,136,136,136,136,136},
{68,68,68,68,68,68,68,68},
{34,34,34,34,34,34,34,34},
{17,17,17,17,17,17,17,17},
{34,34,34,34,34,34,34,34},
{68,68,68,68,68,68,68,68},
{136,136,136,136,136,136,136,136},
{204,204,204,204,204,204,204,204},
{204,204,204,204,204,204,204,204},
{238,238,238,238,238,238,238,238},
{255,255,255,255,255,255,255,255},
{255,255,159,249,159,249,255,255},
{255,255,15,240,15,240,255,255},
{240,15,15,240,15,240,240,15},
{0,0,0,0,0,0,0,0},
{0,128,0,0,0,0,0,0},
{0,200,0,128,0,0,0,0},
{128,236,0,200,0,128,0,0},
{200,254,128,236,0,204,0,128},
{236,255,192,252,0,236,0,192},
{254,255,224,254,224,254,0,224},
{255,255,255,255,240,255,0,252},
{255,255,255,255,248,255,136,255},
{255,255,255,255,252,255,204,255},
{255,255,255,255,255,255,254,255},
{255,255,255,255,255,255,255,255},
{15,255,15,255,15,255,15,255},
{11,187,11,187,11,187,11,187},
{0,0,0,0,0,0,0,0},
{0,0,96,6,96,6,0,0},
{0,0,192,12,192,12,0,0},
{192,12,128,12,0,0,0,0},
{0,204,0,204,0,0,0,0},
{0,102,0,102,0,0,0,0},
{0,51,0,51,0,0,0,0},
{0,0,48,3,48,3,0,0},
{0,0,0,0,51,0,51,0},
{0,0,102,0,102,0,0,0},
{204,0,204,0,0,0,0,0},
{192,12,192,12,0,0,0,0},
{0,0,0,204,0,204,0,0},
{0,0,0,0,0,102,0,102},
{0,0,0,0,48,3,48,3},
{0,0,0,0,51,0,51,0},
{0,0,48,3,48,3,0,0},
{0,0,96,6,96,6,0,0},
{0,0,96,6,96,6,0,0},
{0,0,192,12,192,12,0,0},
{192,12,128,12,0,0,0,0},
{0,204,0,204,0,0,0,0},
{0,102,0,102,0,0,0,0},
{0,51,0,51,0,0,0,0},
{0,0,48,3,48,3,0,0},
{0,0,0,0,51,0,51,0},
{0,0,102,0,102,0,0,0},
{204,0,204,0,0,0,0,0},
{192,12,192,12,0,0,0,0},
{0,0,0,204,0,204,0,0},
{0,0,0,0,0,102,0,102},
{0,0,0,0,48,3,48,3},
{0,0,0,0,51,0,51,0},
{0,0,48,3,48,3,0,0},
{0,0,96,6,96,6,0,0},
{0,0,96,6,96,6,0,0},
{0,0,192,12,192,12,0,0},
{192,12,128,12,0,0,0,0},
{0,204,0,204,0,0,0,0},
{0,102,0,102,0,0,0,0},
{0,51,0,51,0,0,0,0},
{0,0,48,3,48,3,0,0},
{0,0,0,0,51,0,51,0},
{0,0,102,0,102,0,0,0},
{204,0,204,0,0,0,0,0},
{192,12,192,12,0,0,0,0},
{0,0,0,204,0,204,0,0},
{0,0,0,0,0,102,0,102},
{0,0,0,0,48,3,48,3},
{0,0,0,0,51,0,51,0},
{0,0,48,3,48,3,0,0},
{0,0,96,6,96,6,0,0},
{238,0,238,0,0,0,0,0},
{255,0,255,0,0,0,0,0},
{255,15,15,15,255,15,0,0},
{255,255,15,240,15,240,255,255},
{255,255,159,249,159,249,255,255},
{255,255,63,243,63,243,255,255},
{63,243,63,243,255,255,255,255},
{255,51,255,51,255,255,255,255},
{255,255,159,249,159,249,255,255},
{255,255,255,255,204,255,204,255},
{255,255,255,255,136,255,136,255},
{255,255,255,255,0,255,0,255},
{0,0,0,0,0,0,0,0},
{0,15,0,15,0,15,0,15},
{68,68,68,68,68,68,68,68},
{0,15,0,15,0,15,0,15},
{68,68,68,68,68,68,68,68},
{0,15,0,15,0,15,0,15},
{68,68,68,68,68,68,68,68},
{0,15,0,15,0,15,0,15},
{68,68,68,68,68,68,68,68},
{255,0,0,0,0,0,0,0},
{240,15,0,0,0,0,0,0},
{0,255,0,0,0,0,0,0},
{0,240,0,240,0,0,0,0},
{0,0,0,0,0,240,0,240},
{0,0,0,0,0,0,0,255},
{0,0,0,0,0,0,240,15},
{0,0,0,0,0,0,255,0},
{0,0,0,0,15,0,15,0},
{0,0,15,0,15,0,0,0},
{15,0,15,0,0,0,0,0},
{255,0,0,0,0,0,0,0},
{240,15,0,0,0,0,0,0},
{0,255,0,0,0,0,0,0},
{0,240,0,240,0,0,0,0},
{0,0,0,240,0,240,0,0},
{0,0,0,0,0,240,0,240},
{0,0,0,0,0,0,0,255},
{0,0,0,0,0,0,240,15},
{0,0,0,0,0,0,255,0},
{0,0,0,0,15,0,15,0},
{0,0,15,0,15,0,0,0},
{15,0,15,0,0,0,0,0},
{15,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0},
{8,0,0,0,0,0,0,16},
{140,0,8,0,0,16,0,49},
{142,8,8,16,8,16,16,113},
{143,152,8,16,8,16,25,241},
{143,217,9,16,8,144,155,241},
{159,249,9,144,9,144,155,249},
{159,249,9,144,9,144,155,249},
{159,249,9,144,9,144,155,249},
{159,249,9,144,9,144,155,249},
{255,255,0,0,0,0,0,0},
{255,15,0,240,0,0,0,0},
{255,0,0,15,0,240,0,0},
{15,0,240,0,0,15,0,240},
{0,0,15,0,240,0,0,255},
{0,0,0,0,15,0,240,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,240,255,15},
{0,0,0,240,0,15,255,0},
{0,240,0,15,240,0,15,0},
{0,255,240,0,15,0,0,0},
{240,255,15,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,15,0,240,0,0,0,0},
{255,0,0,15,0,240,0,0},
{15,0,240,0,0,15,0,240},
{0,0,15,0,240,0,0,255},
{0,0,0,0,15,0,240,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,240,255,15},
{0,0,0,240,0,15,255,0},
{0,240,0,15,240,0,15,0},
{0,255,240,0,15,0,0,0},
{240,255,15,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,15,0,240,0,0,0,0},
{255,0,0,15,0,240,0,0},
{15,0,240,0,0,15,0,240},
{0,0,15,0,240,0,0,255},
{0,0,0,0,15,0,240,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,240,255,15},
{0,0,0,240,0,15,255,0},
{0,240,0,15,240,0,15,0},
{0,255,240,0,15,0,0,0},
{240,255,15,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,15,0,240,0,0,0,0},
{255,0,0,15,0,240,0,0},
{15,0,240,0,0,15,0,240},
{0,0,15,0,240,0,0,255},
{0,0,0,0,15,0,240,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,240,255,15},
{0,0,0,240,0,15,255,0},
{0,240,0,15,240,0,15,0},
{0,255,240,0,15,0,0,0},
{240,255,15,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,127,0,128,0,0,0,0},
{255,55,0,72,0,128,0,0},
{127,19,128,36,0,72,0,128},
{55,1,72,18,128,36,0,200},
{19,0,36,1,72,18,128,236},
{1,0,18,0,36,1,200,254},
{0,0,1,0,18,0,236,255},
{0,0,0,0,1,0,254,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,16,255,239},
{0,0,0,16,0,33,255,206},
{0,16,0,33,16,66,239,140},
{0,49,16,66,33,132,206,8},
{16,115,33,132,66,8,140,0},
{49,247,66,8,132,0,8,0},
{115,255,132,0,8,0,0,0},
{247,255,8,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,127,0,128,0,0,0,0},
{255,55,0,72,0,128,0,0},
{127,19,128,36,0,72,0,128},
{55,1,72,18,128,36,0,200},
{19,0,36,1,72,18,128,236},
{1,0,18,0,36,1,200,254},
{0,0,1,0,18,0,236,255},
{0,0,0,0,1,0,254,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,16,255,239},
{0,0,0,16,0,33,255,206},
{0,16,0,33,16,66,239,140},
{0,49,16,66,33,132,206,8},
{16,115,33,132,66,8,140,0},
{49,247,66,8,132,0,8,0},
{115,255,132,0,8,0,0,0},
{247,255,8,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,127,0,128,0,0,0,0},
{255,55,0,72,0,128,0,0},
{127,19,128,36,0,72,0,128},
{55,1,72,18,128,36,0,200},
{19,0,36,1,72,18,128,236},
{1,0,18,0,36,1,200,254},
{0,0,1,0,18,0,236,255},
{0,0,0,0,1,0,254,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,0,255,255},
{0,0,0,0,0,16,255,239},
{0,0,0,16,0,33,255,206},
{0,16,0,33,16,66,239,140},
{0,49,16,66,33,132,206,8},
{16,115,33,132,66,8,140,0},
{49,247,66,8,132,0,8,0},
{115,255,132,0,8,0,0,0},
{247,255,8,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,255,0,0,0,0,0,0},
{255,255,0,0,0,0,0,0},

{8,0,0,0,0,0,0,0},
{132,0,8,0,0,0,0,0},
{66,8,132,0,8,0,0,0},
{33,132,66,8,132,0,8,0},
{16,66,33,132,66,8,132,0},
{0,33,16,66,33,132,66,8},
{0,16,0,33,16,66,33,132},
{0,0,0,16,0,33,16,66},
{0,0,0,0,0,16,0,33},
{0,0,0,0,0,0,0,16},

{8,0,0,0,0,0,0,0},
{132,0,8,0,0,0,0,0},
{66,8,132,0,8,0,0,0},
{33,132,66,8,132,0,8,0},
{16,66,33,132,66,8,132,0},
{0,33,16,66,33,132,66,8},
{0,16,0,33,16,66,33,132},
{0,0,0,16,0,33,16,66},
{0,0,0,0,0,16,0,33},
{0,0,0,0,0,0,0,16},

{8,0,0,0,0,0,0,0},
{132,0,8,0,0,0,0,0},
{66,8,132,0,8,0,0,0},
{33,132,66,8,132,0,8,0},
{16,66,33,132,66,8,132,0},
{0,33,16,66,33,132,66,8},
{0,16,0,33,16,66,33,132},
{0,0,0,16,0,33,16,66},
{0,0,0,0,0,16,0,33},
{0,0,0,0,0,0,0,16},

{8,0,0,0,0,0,0,0},
{132,0,8,0,0,0,0,0},
{66,8,132,0,8,0,0,0},
{33,132,66,8,132,0,8,0},
{16,66,33,132,66,8,132,0},
{0,33,16,66,33,132,66,8},
{0,16,0,33,16,66,33,132},
{0,0,0,16,0,33,16,66},
{0,0,0,0,0,16,0,33},
{0,0,0,0,0,0,0,16},

{8,0,0,0,0,0,0,0},
{132,0,8,0,0,0,0,0},
{66,8,132,0,8,0,0,0},
{33,132,66,8,132,0,8,0},
{16,66,33,132,66,8,132,0},
{0,33,16,66,33,132,66,8},
{0,16,0,33,16,66,33,132},
{0,0,0,16,0,33,16,66},
{0,0,0,0,0,16,0,33},
{0,0,0,0,0,0,0,16},


{8,0,0,0,0,0,0,16},
{4,0,0,0,0,0,0,32},
{2,0,0,0,0,0,0,64},
{1,0,0,0,0,0,0,128},
{16,0,0,0,0,0,0,8},
{0,0,16,0,0,8,0,0},
{0,0,0,8,16,0,0,0},
{0,0,128,0,0,1,0,0},
{128,0,0,0,0,0,0,1},
{8,0,0,0,0,0,0,16},
{4,0,0,0,0,0,0,32},
{64,0,0,0,0,0,0,2},
{128,0,0,0,0,0,32,0},
{0,0,128,0,0,0,16,0},
{0,0,64,0,16,0,0,0},
{0,0,0,3,0,0,0,0},
{0,1,32,0,0,0,0,0},
{32,2,0,0,0,0,0,0},
{64,32,0,0,0,0,0,0},
{0,68,0,0,0,0,0,0},
{0,128,0,0,0,0,0,0},
{0,128,0,0,0,0,0,0},
{239,236,118,223,252,52,86,90},
{239,236,118,215,252,52,86,90},
{239,236,54,215,252,52,86,90},
{111,236,50,215,252,52,86,90},
{105,236,50,215,252,52,86,90},
{97,236,50,215,244,52,86,90},
{97,236,50,215,112,52,82,90},
{97,236,50,211,48,52,80,90},
{97,236,50,211,48,48,64,88},
{97,228,50,211,16,48,0,80},
{65,228,0,211,16,48,0,80},
{0,224,0,211,0,48,0,80},
{0,224,0,19,0,48,0,0},
{0,224,0,1,0,0,0,0},
{0,0,0,0,0,0,0,0},


{8,0,0,0,0,0,0,16},
{4,0,0,0,0,0,0,32},
{2,0,0,0,0,0,0,64},
{1,0,0,0,0,0,0,128},
{16,0,0,0,0,0,0,8},
{0,0,16,0,0,8,0,0},
{0,0,0,8,16,0,0,0},
{0,0,128,0,0,1,0,0},
{128,0,0,0,0,0,0,1},
{8,0,0,0,0,0,0,16},
{4,0,0,0,0,0,0,32},
{64,0,0,0,0,0,0,2},
{128,0,0,0,0,0,32,0},
{0,0,128,0,0,0,16,0},
{0,0,64,0,16,0,0,0},
{0,0,0,3,0,0,0,0},
{0,1,32,0,0,0,0,0},
{32,2,0,0,0,0,0,0},
{64,32,0,0,0,0,0,0},
{0,68,0,0,0,0,0,0},
{0,128,0,0,0,0,0,0},
{0,128,0,0,0,0,0,0},
{239,236,118,223,252,52,86,90},
{239,236,118,215,252,52,86,90},
{239,236,54,215,252,52,86,90},
{111,236,50,215,252,52,86,90},
{105,236,50,215,252,52,86,90},
{97,236,50,215,244,52,86,90},
{97,236,50,215,112,52,82,90},
{97,236,50,211,48,52,80,90},
{97,236,50,211,48,48,64,88},
{97,228,50,211,16,48,0,80},
{65,228,0,211,16,48,0,80},
{0,224,0,211,0,48,0,80},
{0,224,0,19,0,48,0,0},
{0,224,0,1,0,0,0,0},
{0,0,0,0,0,0,0,0},


{8,0,0,0,0,0,0,16},
{4,0,0,0,0,0,0,32},
{2,0,0,0,0,0,0,64},
{1,0,0,0,0,0,0,128},
{16,0,0,0,0,0,0,8},
{0,0,16,0,0,8,0,0},
{0,0,0,8,16,0,0,0},
{0,0,128,0,0,1,0,0},
{128,0,0,0,0,0,0,1},
{8,0,0,0,0,0,0,16},
{4,0,0,0,0,0,0,32},
{64,0,0,0,0,0,0,2},
{128,0,0,0,0,0,32,0},
{0,0,128,0,0,0,16,0},
{0,0,64,0,16,0,0,0},
{0,0,0,3,0,0,0,0},
{0,1,32,0,0,0,0,0},
{32,2,0,0,0,0,0,0},
{64,32,0,0,0,0,0,0},
{0,68,0,0,0,0,0,0},
{0,128,0,0,0,0,0,0},
{0,128,0,0,0,0,0,0},
{239,236,118,223,252,52,86,90},
{239,236,118,215,252,52,86,90},
{239,236,54,215,252,52,86,90},
{111,236,50,215,252,52,86,90},
{105,236,50,215,252,52,86,90},
{97,236,50,215,244,52,86,90},
{97,236,50,215,112,52,82,90},
{97,236,50,211,48,52,80,90},
{97,236,50,211,48,48,64,88},
{97,228,50,211,16,48,0,80},
{65,228,0,211,16,48,0,80},
{0,224,0,211,0,48,0,80},
{0,224,0,19,0,48,0,0},
{0,224,0,1,0,0,0,0},
{0,0,0,0,0,0,0,0},


{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},



{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},



{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},
{90,90,165,165,90,90,165,165},
{165,165,90,90,165,165,90,90},


{15,0,0,0,0,0,0,0},
{240,0,0,0,0,0,0,0},
{0,15,0,0,0,0,0,0},
{0,240,0,0,0,0,0,0},
{0,224,0,16,0,0,0,0},
{0,192,0,32,0,16,0,0},
{0,128,0,64,0,32,0,16},
{0,8,0,4,0,2,0,1},
{128,0,64,0,32,0,16,0},
{8,0,4,0,2,0,1,0},
{8,0,4,0,4,0,2,0},
{8,0,8,0,8,0,8,0},
{136,0,136,0,136,0,136,0},
{200,0,200,0,200,0,200,0},
{200,4,200,4,200,4,200,4},
{200,12,200,12,200,12,200,12},
{200,140,200,140,200,140,200,140},
{200,204,200,204,200,204,200,204},
{200,236,200,236,200,236,200,236},
{200,252,200,252,200,252,200,252},
{200,253,200,253,200,253,200,253},
{200,255,200,255,200,255,200,255},
{232,255,232,255,232,255,232,255},
{248,255,248,255,248,255,248,255},
{249,255,249,255,249,255,249,255},
{251,255,251,255,251,255,251,255},
{255,255,255,255,255,255,255,255},
{255,255,255,255,255,255,255,255},
{255,255,255,255,255,255,255,255},
{0,0,0,0,0,0,0,0},
{255,255,255,255,255,255,255,255},
{0,0,0,0,0,0,0,0},
{255,255,255,255,255,255,255,255},
{0,0,0,0,0,0,0,0},
{255,255,255,255,255,255,255,255},
{0,0,0,0,0,0,0,0},
{255,255,255,255,255,255,255,255},


{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},
{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},
{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},

{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},
{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},
{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},

{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},
{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},
{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},

{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},
{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},
{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},

{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},
{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},
{15,240,15,240,15,240,15,240},
{240,15,240,15,240,15,240,15},


};
uint16_t FilmPos = 0;
uint16_t FilmIntervalCount = 0;


///////////////////////////////////////////
//         0
///////////////////////////////////////////
void clear_RXBuffer(void) {
  for (RXi=0;RXi<RX_BUF_SIZE;RXi++)
    RXBuffer[RXi] = 0;
  RXi = 0;
}


//    
uint32_t pow_10(uint8_t i)
{
  uint16_t uiData;

  if (i==0) return 1;

  uiData=10;
  i=i-1;
  while(i) {
	uiData *= 10; 
    i--;
  }
  return uiData;
}


uint8_t StrToInt (uint8_t* _buffer) {
  uint8_t result;
  uint8_t x10;
  uint8_t pos;
  
  result = 0;
  pos = 0;

  //  
  while (_buffer[pos] != 0) {
    pos++;
  }

  x10 = 0;
  pos--;
  
  while ((_buffer[pos] > 47) && (_buffer[pos] < 58) && (pos >= 0)) {
	result += (_buffer[pos]-48) * pow_10(x10);
	pos--;
	x10++;
  }

  return result;
}


///////////////////////////////////////////
//    
///////////////////////////////////////////
void set_LED(uint8_t byte0, uint8_t byte1, uint8_t key) {
  uint8_t n;
  uint16_t led_data;

  KEY_PORT = ~((1<<KEY_1) | (1<<KEY_2) | (1<<KEY_3) | (1<<KEY_4));

  led_data = (byte1 << 8) + byte0;

  //    
  LED_PORT &= ~(1<<LED_RESET);
  //_delay_us(1);
  LED_PORT |= (1<<LED_RESET);
  //_delay_us(1);


  //  
  for(n=0;n<16;n++) {
    LED_PORT = (0x01 & (led_data>>n)) | (LED_PORT & 0xFE);
    LED_PORT &= ~(1<<LED_CLK);
    //_delay_us(1);
    LED_PORT |= (1<<LED_CLK);
    //_delay_us(1);
  }
  
  KEY_PORT |= (1<<key);
  //_delay_ms(1);
}


ISR(TIMER0_OVF_vect) {
  if (LEDR==0)
    set_LED (LEDbyte[0],LEDbyte[1], KEY_1);

  if (LEDR==1)
    set_LED (LEDbyte[2],LEDbyte[3], KEY_2);

  if (LEDR==2)
    set_LED (LEDbyte[4],LEDbyte[5], KEY_3);

  if (LEDR==3)
    set_LED (LEDbyte[6],LEDbyte[7], KEY_4);

  LEDR++;
  if (LEDR > 3)
    LEDR = 0;
}


ISR(TIMER2_OVF_vect) {
  FilmIntervalCount++;
}


void Uart_Recv() {
  //   
  RXc = uart_getc();
  if ((RXc != 256) && (RXc != 0) && (RXc != 10) && (FLAG_COMMAND == 0)) {
    uart_putc(RXc);
    if (RXc != 13) {  //   
	  RXBuffer[RXi] = RXc;
	  RXi++;
    }
    else {
      FLAG_COMMAND = 1;
	  FLAG_AUTORUN = 0;
    }
  }

  if (RXi > RX_BUF_SIZE-1) {
    clear_RXBuffer();
  }
}


int main( void )
{	 
  uint8_t i, j, n;
  uint8_t str[8];

  //   
  clear_RXBuffer(); //  
  uart_init(RXUBRR);
 
  //   
  LED_PORT_DDR |= ((1<<LED_DSA) | (1<<LED_CLK) | (1<<LED_RESET));  
  LED_PORT |= ((1<<LED_DSA) | (1<<LED_CLK) | (1<<LED_RESET));

  //   
  KEY_PORT_DDR |= ((1<<KEY_1) | (1<<KEY_2) | (1<<KEY_3) | (1<<KEY_4));
  KEY_PORT &= ~((1<<KEY_1) | (1<<KEY_2) | (1<<KEY_3) | (1<<KEY_4));
  
  //  
  TCCR0 = (1<<CS01) | (1<<CS00);
    
  TCCR2 = ((1<<CS22) | (0<<CS21) | (0<<CS20));
  TIMSK = (1<<TOIE0) | (1<<TOIE2);

  sei();

  uart_puts("LED CUBE V1.0 (c) Koryagin Andrey 2010\r\n");

  FLAG_AUTORUN = 1;

  while(1) {
	// ------------------------------------
	//   ,       
	// ------------------------------------	
	if (FLAG_AUTORUN == 1) {
      if (FilmIntervalCount > FilmInterval) {
	    FilmIntervalCount = 0;
	    for (i=0;i<8;i++) {
          LEDbyte[i] = pgm_read_byte(&FilmData[FilmPos][i]);
	    }
        FilmPos++;
	    if (FilmPos > (FilmLength-1)) {
	      FilmPos = 0;
	    }
	  }
	}	
	
	// ------------------------------------
	//     
	// ------------------------------------
    if (FLAG_COMMAND == 1) {
	  strupr(RXBuffer);

	  uart_puts("\r\n");
      if (strcmp(RXBuffer,"AT") == 0) { // AT
        uart_puts("OK");
	  }

      if (strcmp(RXBuffer,"OFF") == 0) { // OFF
        for (i=0;i<8;i++) {
          LEDbyte[i] = 0;
		}
		uart_puts("OK");
	  }

      if (strcmp(RXBuffer,"ON") == 0) { // ON
        for (i=0;i<8;i++) {
          LEDbyte[i] = 255;
		}
		uart_puts("OK");
	  }

	  if (strcmp(RXBuffer,"RUN") == 0) { // RUN
        FilmPos = 0;
		FLAG_AUTORUN = 1;
	  }

	  strncpy (str,RXBuffer,4);
      str[4]='\0';
	  if (strcmp(str,"SET ") == 0) { // SET KADR
		i = 4; // 
		j = 0;
		n = 0; //   (8 )
		while (i < RX_BUF_SIZE) {		  
		  if (RXBuffer[i] == ',') {
            str[j] = '\0';
			RXbyte[n] = StrToInt(str);
		    n++;
			j = 0;
		  }
		  else {
            str[j] = RXBuffer[i];
			j++;
		  }
		  		  
		  i++;
		}

		if (n==8) { //  -  
		  for (i=0;i<8;i++) {
            LEDbyte[i] = RXbyte[i];
		  }
		  uart_puts("OK");
		}
		else {
          uart_puts("ERROR");
		}

	  }

      clear_RXBuffer();
	  FLAG_COMMAND = 0;
	  uart_puts("\r\n");
	}

  }

}
