#ifndef WG_LIB
#define WG_LIB

#define LCD_RST	0b00000001
#define LCD_E	0b00000010
#define LCD_RW	0b00000100
#define LCD_RS	0b00001000
#define LCD_CS2	0b00010000
#define LCD_CS1	0b00100000

#define LCD_DPORT	PORTD
#define LCD_DPIN	PIND
#define LCD_DIO		DDRD
#define LCD_COM		PORTC
#define LCD_CIO		DDRC

void WG_WriteCom(unsigned char Com,unsigned char CS);
void WG_WriteData(unsigned char data,unsigned char CS);
void WG_WriteXY(unsigned char x,unsigned char y,const unsigned char CS);
void WG_SetTextXY(unsigned char x, unsigned y);
void WG_init_lcd(void);
void WG_clear(void);
unsigned char WG_gotoxy(unsigned char x, unsigned y);
void WG_putc (unsigned char data, unsigned char inv);
void WG_put_big_number (uint8_t n, unsigned char inv);
void WG_puts (unsigned char x, unsigned char y, unsigned char str[],unsigned char n,unsigned char inv);
unsigned char WG_ReadData(unsigned char CS);
void WG_getc (unsigned char data[],unsigned char readx,unsigned ready);
void WG_DelCur(void);
void WG_SetCur(unsigned char x, unsigned char y);
void show_img(const char* img, uint8_t sx, uint8_t sy,  uint8_t x, uint8_t y);

unsigned char 
	textx,
	texty,
	curx,
	cury,
	ch[6];

#endif
