#include <stdio.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include "i2cmaster.h"

//#define F_CPU 3686400L

//  XCLR 
#define XCLR_DDR DDRD 
#define XCLR_PORT PORTD 
#define XCLR PIND0

//    
#define MCLK_DDR DDRD
#define MCLK_PORT PORTD
#define MCLK PIND1

//  
long int c1, c2, c3, c4, c5, c6, c7, a, b, c, d;
//  
long int d1, d2;
// 
long int t;
// 
long int Pressure;


//#############################################################################
//    
//
long int pow2(uint8_t i)
{
  long int uiData;
  uiData=2;
  i=i-1;
  while(i) {
	uiData *= 2; 
    i--;
  }
  return uiData;
}



#define fospEEPROM_ADR  0xA0    //  EEPROM
#define fospADC_ADR     0xEE    //  ADC
#define PRESSURE        0xF0
#define TEMPERATURE     0xE8
#define mm_rt_st        0.7500638    // . . . (@ 0 . C)
//#############################################################################
//  HP03
//
void HP03Init(void)
{
  //  HP03
  XCLR_PORT &= ~(1<<XCLR);
  _delay_ms(200);
  XCLR_PORT |= (1<<XCLR);
  _delay_ms(200);
  XCLR_PORT &= ~(1<<XCLR);
  _delay_ms(200);
}

//#############################################################################
//   
//
unsigned int HP03_Get2Bytes()
{
  unsigned int HiTemp, LowTemp;
  HiTemp=i2c_readAck();
  LowTemp=i2c_readAck();
  return (((int)HiTemp) << 8) + LowTemp;
}

//#############################################################################
//     EEPROM (HP03)
//
void HP03ReadCoeff(void)
{
  unsigned int ret;

  ret = i2c_start(fospEEPROM_ADR);    //  EEPROM

  if(ret)
  {
    //   
    i2c_stop();
  }  
  else
  {
	i2c_write(0x10);                  //    EEPROM
    i2c_start(0xA1);
    
	c1=HP03_Get2Bytes();
	c2=HP03_Get2Bytes();
	c3=HP03_Get2Bytes();
	c4=HP03_Get2Bytes();
	c5=HP03_Get2Bytes();
	c6=HP03_Get2Bytes();
	c7=HP03_Get2Bytes();
    
    a = i2c_readAck();
    b = i2c_readAck();
	c = i2c_readAck();
    d = i2c_readNak();

    i2c_stop();
  }
}

//#############################################################################
//    (HP03)
//
unsigned int HP03ReadValue(unsigned char n)
{
  
  unsigned int ret;
  unsigned int temp;
  temp = 0;

  ret=i2c_start(fospADC_ADR);	//  ADC
    
  if(ret)
  {
    //   
    i2c_stop();
  }  
  else
  {
    i2c_write(0xff);
    i2c_write(n);				// Pressure(0xF0), Temperature(0xE8)
    i2c_stop();
  
    _delay_ms(50);
  
    i2c_start(fospADC_ADR);		//  ADC
    i2c_write(0xfd);
  
    i2c_rep_start(0XEF);		//  ADC
    
	temp = HP03_Get2Bytes();
  
    i2c_stop();
  }

  return temp;

}

//#############################################################################
//     
//    
//
void PressureTemperatureMeasure(void)
{
  long int  dUT;
  long int  off, sens, x;
 
  
  XCLR_PORT |= (1<<XCLR); 
  
  d1 = HP03ReadValue(PRESSURE);
  d2 = HP03ReadValue(TEMPERATURE);

  XCLR_PORT &= ~(1<<XCLR);
  
  //if(d2 >= c5) { dUT = (d2-c5) - (((d2-c5)/pow2(7))*((d2-c5)/pow2(7))*a)/pow2(c); }
  //else {         dUT = (d2-c5) - (((d2-c5)/pow2(7))*((d2-c5)/pow2(7))*b)/pow2(c); }
  if(d2 >= c5) { t = a; }
  else { t = b; }
  dUT = (d2-c5) - (((d2-c5)/pow2(7))*((d2-c5)/pow2(7))*t)/pow2(c);
 

  t = (250 + ((dUT*c6)/pow2(16)) - dUT/pow2(d));///10; //       
  
  off = (c2+(c4-1024)*dUT/pow2(14))*4;
  sens = c1+(c3*dUT)/pow2(10);
  x = (sens*(d1-7168))/pow2(14)-off;
  
  //Pressure = (x*100/pow2(5)+c7*10);
  Pressure = ((x*100/pow2(5)+c7*10)/100)*mm_rt_st;    //      
}

//=============================================================================


//#############################################################################
//   
//    3.6864 
//
ISR(TIMER0_OVF_vect) {
  if ((MCLK_PORT & (1<<MCLK)) == 0) {
    MCLK_PORT |= (1<<MCLK);
  }
  else {
	MCLK_PORT &= ~(1<<MCLK);
  }
}


//#############################################################################
//#############################################################################
int main(void){
   
  //       
  XCLR_DDR |= (1<<XCLR);
  MCLK_DDR |= (1<<MCLK);

  //     
  TCCR0 = (1<<CS00);

  //  
  TIMSK = (1<<TOIE0);
     
  //  
  TCNT0 = 0;   
 
  sei(); 

  i2c_init();
  
  // TWI PULL UP    ,      .
  PORTC |= ((1<<PINC4) | (1<<PINC5));
 
  HP03Init();
  HP03ReadCoeff();
 

  while(1) {
      PressureTemperatureMeasure();
	  //  
	  // t - 
	  // Pressure - 
  }

}
