#include <stdio.h>
#include <avr/io.h>
#include <util/delay.h>

//    DSA, DSA, RESET
#define LCD_DSA_PORT PORTC
#define LCD_DSA_PORT_DDR DDRC
#define LCD_DSA PINC5
#define LCD_CLK_PORT PORTC
#define LCD_CLK_PORT_DDR DDRC
#define LCD_CLK PINC4
#define LCD_RESET_PORT PORTC
#define LCD_RESET_PORT_DDR DDRC
#define LCD_RESET PINC3

uint8_t LCDFlag;

//1  - 
//2  -  
//4  - 
//8  -  
//16 -  
//32 - 
//64 -  
//128- 
#define LCD_NULL 0
#define LCD_DOT 1
#define LCD0 2+4+8+16+32+64 
#define LCD1 8+16 
#define LCD2 32+16+128+2+4
#define LCD3 32+16+128+8+4
#define LCD4 64+128+16+8
#define LCD5 32+64+128+8+4
#define LCD6 64+128+2+4+8+32
#define LCD7 32+16+8
#define LCD8 2+4+8+128+64+16+32
#define LCD9 64+32+16+128+8+4

const uint8_t NSymbol[] = {LCD0, LCD1, LCD2, LCD3, LCD4, LCD5, LCD6, LCD7, LCD8, LCD9};

//     LCD    0  999
void LCD7_Show_Int(int value) {
  uint8_t byte[3];
  uint8_t b,n;

  byte[2] = value/100;
  byte[1] = (value-byte[2]*100)/10;
  byte[0] = (value - byte[2]*100 - byte[1]*10);

  //    
  LCD_RESET_PORT &= ~(1<<LCD_RESET);
  LCD_RESET_PORT |= (1<<LCD_RESET);

  
  //  3
  if (byte[2] > 0)
    byte[2] = NSymbol[byte[2]];
  else
    byte[2] = LCD_NULL;
 
  //  2
  if ((byte[1] > 0) || (byte[2] > 0))
	byte[1] = NSymbol[byte[1]];
  else
    byte[1] = LCD_NULL;
 
  //  1
  byte[0] = NSymbol[byte[0]];

  //     
  if (LCDFlag == 0) {
    byte[2] &= 254;
	LCDFlag = 1;
  }
  else {
    byte[0] = ~byte[0];
    byte[1] = ~byte[1];
    byte[2] = ~byte[2] | 1;
	LCDFlag = 0;
  }

  //     
  for(b=0; b<3; b++) {  
	for(n=0; n<8; n++) {
	  if ((0x01 & (byte[b]>>n)) == 1)
	    LCD_DSA_PORT |= (1<<LCD_DSA);
	  else
		LCD_DSA_PORT &= ~(1<<LCD_DSA);

      LCD_CLK_PORT &= ~(1<<LCD_CLK);
      LCD_CLK_PORT |= (1<<LCD_CLK);
    }
  }

}

int main( void )
{	 

  //    DSA, DSA, RESET
  LCD_DSA_PORT_DDR |= (1<<LCD_DSA);
  LCD_CLK_PORT_DDR |= (1<<LCD_CLK);
  LCD_RESET_PORT_DDR |= (1<<LCD_RESET);

  while(1) {
    LCD7_Show_Int(123); //    0  999
	_delay_us(100);
	
  }

}
