#include <stdio.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>

#define POINTS 128

#define SYMB_COUNT 120 // !!!   POINTS !!!
const char symb[] = {
0b01111100,0b10000010,0b10000010,0b10000010,0b01000100,//
0x00,0x00,0x00,0x00,0x00,

0b11111110,0b00010000,0b00010000,0b00010000,0b11111110, //H
0x00,0x00,
0b00011100,0b00100010,0b00100010,0b00100010,0b00011100, //
0x00,0x00,
0b00111110,0b00101010,0b00101010,0b00010100,0b00000000, //
0x00,0x00,
0b00111110,0b00001010,0b00001010,0b00000100,0b00111110, //
0x00,0x00,
0b00111110,0b00010000,0b00001000,0b00010000,0b00111110, //
0x00,0x00,0x00,0x00,0x00,

0b11111110,0b10000000,0b10000000,0b10000000,0b11000000, //
0x00,0x00,
0b00011100,0b00100010,0b00100010,0b00100010,0b00011100, //
0x00,0x00,
0b00000111,0b00101010,0b00110010,0b00100010,0b00111111, //
0x00,0x00,
0b00011100,0b00100010,0b00100010,0b00100010,0b00011100, //
0x00,0x00,
0b00111110,0b00010000,0b00001000,0b00010000,0b00111110, //
0x00,0x00,
0b00000000,0b00000000,0b11110010,0b00000000,0b00000000, //!

0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00

};
int symb_pos;

long int Rotation_time, Rotation_count;
void start_timer () {
int value;

value = 0xFFFF - Rotation_time / POINTS;

if (value > 0xFFFF - 10)
TCNT1 = 0xFFFF - 10;
else
TCNT1 = value;

}

ISR(INT1_vect) {
//      
Rotation_time = Rotation_count + TCNT0;
//      
Rotation_count = 0;
TCNT0 = 0x00;

//  ,   
start_timer();
symb_pos = 0;
}

ISR(TIMER0_OVF_vect) {
Rotation_count +=255;
}

ISR(TIMER1_OVF_vect) {
start_timer();
PORTB = ~symb[symb_pos];
if (symb_pos < SYMB_COUNT)
symb_pos++;
}

int main( void )
{

//   
DDRB = 255;
//         
PORTD |= (1<<3);
//  
MCUCR = ((1<<ISC10) | (1<<ISC11)); //     
GICR = (1<<INT1); //     

//set timer counter initial value
TCNT0 = 0x00;
TCNT1 = 0x00;

//start timer without presscaler
TCCR0 = 1<<CS00;
TCCR1B = 1<<CS10;

//enable timer overflow interrupt
TIMSK = ((1<<TOIE0) | (1<<TOIE1));

Rotation_time = 0xFFFF;

sei();
symb_pos = 0;

while(1) {

}

}
